using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class PATIENTDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public PATIENTDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public PATIENT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            PATIENT objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, PATIENT objSave)
        {
            Int32? objReturn = objSave.PATIENT_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_PATIENT_save(CURRENT_USER, CURRENT_REGISTRY_ID, ref objReturn, objSave.FIRST_NAME, objSave.MIDDLE_NAME, objSave.LAST_NAME, objSave.EMAIL_ADDRESS, objSave.BIRTH_DATE, objSave.DEATH_DATE, objSave.CELL_PHONE, objSave.PERFERRED_ADDRESS_TYPE, objSave.CREATEDBY, DateTime.Now, objSave.UPDATEDBY, DateTime.Now, objSave.OEFOIF_IND, objSave.PATIENTSID, objSave.PatientICN);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public PATIENT GetItemComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            PATIENT objReturn = null;
            PatientComplete objTemp = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objTemp = dbContext.usp_PATIENT_getitemComplete(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).FirstOrDefault();
                    if (objTemp != null)
                    {
                        objReturn = new PATIENT
                        {
                            BIRTH_DATE = objTemp.BIRTH_DATE,
                            CELL_PHONE = objTemp.CELL_PHONE,
                            CREATED = objTemp.CREATED,
                            CREATEDBY = objTemp.CREATEDBY,
                            DEATH_DATE = objTemp.DEATH_DATE,
                            EMAIL_ADDRESS = objTemp.EMAIL_ADDRESS,
                            FIRST_NAME = objTemp.FIRST_NAME,
                            LAST_NAME = objTemp.LAST_NAME,
                            MIDDLE_NAME = objTemp.MIDDLE_NAME,
                            OEFOIF_IND = objTemp.OEFOIF_IND,
                            PATIENT_ID = objTemp.PATIENT_ID,
                            PATIENTSID = objTemp.PATIENTSID,
                            PERFERRED_ADDRESS_TYPE = objTemp.PERFERRED_ADDRESS_TYPE,
                            UPDATED = objTemp.UPDATED,
                            UPDATEDBY = objTemp.UPDATEDBY,
                            PatientICN = objTemp.PatientICN,
                            MULTI_RACE_INDICATOR = objTemp.MULTI_RACE_INDICATOR,
                            MULTI_ETHNICITY_INDICATOR = objTemp.MULTI_ETHNICITY_INDICATOR,
                            SPATIENT = new SPATIENT
                            {
                                AddressChangeInstitutionIEN = objTemp.AddressChangeInstitutionIEN,
                                AddressChangeInstitutionSID = objTemp.AddressChangeInstitutionSID,
                                AddressChangeStaffIEN = objTemp.AddressChangeStaffIEN,
                                AddressChangeStaffSID = objTemp.AddressChangeStaffSID,
                                Age = objTemp.Age,
                                BadAddressIndicator = objTemp.BadAddressIndicator,
                                CDDeterminingInstitutionIEN = objTemp.CDDeterminingInstitutionIEN,
                                City = objTemp.City,
                                CombatFromVistaDate = objTemp.CombatFromVistaDate,
                                CombatToVistaDate = objTemp.CombatToVistaDate,
                                ConfidentialAddressActiveFlag = objTemp.ConfidentialAddressActiveFlag,
                                Country = objTemp.Country,
                                CountryIEN = objTemp.CountryIEN,
                                CountrySID = objTemp.CountrySID,
                                County = objTemp.County,
                                Created = objTemp.Created,
                                CreatedBy = objTemp.CreatedBy,
                                CurrentMeansTestStatusIEN = objTemp.CurrentMeansTestStatusIEN,
                                DateOfBirth = objTemp.DateOfBirth,
                                DateOfBirthText = objTemp.DateOfBirthText,
                                DateOfDeath = objTemp.DateOfDeath,
                                DateOfDeathText = objTemp.DateOfDeathText,
                                Deceased = objTemp.Deceased,
                                DEFAULT_RECORD = objTemp.DEFAULT_RECORD,
                                Eligibility = objTemp.Eligibility,
                                EligibilityIEN = objTemp.EligibilityIEN,
                                EligibilitySID = objTemp.EligibilitySID,
                                EligibilityStatus = objTemp.EligibilityStatus,
                                EligibilityVACode = objTemp.EligibilityVACode,
                                EligibilityVerificationSource = objTemp.EligibilityVerificationSource,
                                EmailAddress = objTemp.EmailAddress,
                                EnteredIntoFileDate = objTemp.EnteredIntoFileDate,
                                EnteredIntoFileDateTransformSID = objTemp.EnteredIntoFileDateTransformSID,
                                EnteredIntoFileVistaErrorDate = objTemp.EnteredIntoFileVistaErrorDate,
                                ETLBatchID = objTemp.ETLBatchID,
                                ExcludeFromFacilityDirectoryFlag = objTemp.ExcludeFromFacilityDirectoryFlag,
                                Gender = objTemp.Gender,
                                GISAddressType = objTemp.GISAddressType,
                                GISAddressUpdatedDate = objTemp.GISAddressUpdatedDate,
                                GISCongressDistrict = objTemp.GISCongressDistrict,
                                GISFIPSCode = objTemp.GISFIPSCode,
                                GISLocatorName = objTemp.GISLocatorName,
                                GISMarket = objTemp.GISMarket,
                                GISMatchedAddress = objTemp.GISMatchedAddress,
                                GISMatchMethodCode = objTemp.GISMatchMethodCode,
                                GISMatchScore = objTemp.GISMatchScore,
                                GISMatchStatusCode = objTemp.GISMatchStatusCode,
                                GISPatientAddressLatitude = objTemp.GISPatientAddressLatitude,
                                GISPatientAddressLongitude = objTemp.GISPatientAddressLongitude,
                                GISSector = objTemp.GISSector,
                                GISStreetSide = objTemp.GISStreetSide,
                                GISSubmarket = objTemp.GISSubmarket,
                                GISURH = objTemp.GISURH,
                                InsuranceCoverageFlag = objTemp.InsuranceCoverageFlag,
                                LastServiceEntryDate = objTemp.LastServiceEntryDate,
                                LastServiceEntryDateTransformSID = objTemp.LastServiceEntryDateTransformSID,
                                LastServiceEntryVistaErrorDate = objTemp.LastServiceEntryVistaErrorDate,
                                LastServiceSeparationDate = objTemp.LastServiceSeparationDate,
                                LastServiceSeparationDateTransformSID = objTemp.LastServiceSeparationDateTransformSID,
                                LastServiceSeparationVistaErrorDate = objTemp.LastServiceSeparationVistaErrorDate,
                                MaritalStatus = objTemp.MaritalStatus,
                                MaritalStatusIEN = objTemp.MaritalStatusIEN,
                                MaritalStatusSID = objTemp.MaritalStatusSID,
                                MedicaidNumber = objTemp.MedicaidNumber,
                                MothersMaidenName = objTemp.MothersMaidenName,
                                OEF_OIF_IND = objTemp.SOEF_OIF_IND,
                                OpCode = objTemp.OpCode,
                                Patient_ID = objTemp.Patient_ID,
                                PatientFirstName = objTemp.PatientFirstName,
                                PatientICN = objTemp.SPatientICN,
                                PatientICNChecksum = objTemp.PatientICNChecksum,
                                PatientIEN = objTemp.PatientIEN,
                                PatientLastName = objTemp.PatientLastName,
                                PatientName = objTemp.PatientName,
                                PatientSID = objTemp.PatientSID,
                                PatientSnum = objTemp.PatientSnum,
                                PercentServiceConnect = objTemp.PercentServiceConnect,
                                PeriodOfService = objTemp.PeriodOfService,
                                PeriodOfServiceIEN = objTemp.PeriodOfServiceIEN,
                                PeriodOfServiceSID = objTemp.PeriodOfServiceSID,
                                PhoneCellular = objTemp.PhoneCellular,
                                PhoneResidence = objTemp.PhoneResidence,
                                PhoneWork = objTemp.PhoneWork,
                                PK_ID = objTemp.PK_ID,
                                PostalCode = objTemp.PostalCode,
                                POWLocationIEN = objTemp.POWLocationIEN,
                                PreferredInstitutionIEN = objTemp.PreferredInstitutionIEN,
                                Province = objTemp.Province,
                                PseudoSSNFlag = objTemp.PseudoSSNFlag,
                                PurpleHeartInstitutionIEN = objTemp.PurpleHeartInstitutionIEN,
                                Race = objTemp.Race,
                                RaceIEN = objTemp.RaceIEN,
                                RaceSID = objTemp.RaceSID,
                                Religion = objTemp.Religion,
                                ReligionIEN = objTemp.ReligionIEN,
                                ReligionSID = objTemp.ReligionSID,
                                RoomBedIEN = objTemp.RoomBedIEN,
                                ScrSnum = objTemp.ScrSnum,
                                SensitiveFlag = objTemp.SensitiveFlag,
                                Sta3n = objTemp.Sta3n,
                                State = objTemp.State,
                                StateIEN = objTemp.StateIEN,
                                StateSID = objTemp.StateSID,
                                STD_COMBATLOCATION_ID = objTemp.STD_COMBATLOCATION_ID,
                                STD_ENTHNICITY_ID = objTemp.STD_ENTHNICITY_ID,
                                STD_GENDER_ID = objTemp.STD_GENDER_ID,
                                STD_MARITALSTATUS_ID = objTemp.STD_MARITALSTATUS_ID,
                                STD_RACE_ID = objTemp.STD_RACE_ID,
                                STD_SERVICEBRANCH_ID = objTemp.STD_SERVICEBRANCH_ID,
                                StdRegistryId = objTemp.StdRegistryId,
                                StreetAddress1 = objTemp.StreetAddress1,
                                StreetAddress2 = objTemp.StreetAddress2,
                                StreetAddress3 = objTemp.StreetAddress3,
                                TemporaryAddressChangeInstitutionIEN = objTemp.TemporaryAddressChangeInstitutionIEN,
                                Updatedate = objTemp.Updatedate,
                                UpdatedBy = objTemp.UpdatedBy,
                                VeteranFlag = objTemp.VeteranFlag,
                                VistaCreateDate = objTemp.VistaCreateDate,
                                VistaEditDate = objTemp.VistaEditDate,
                                Zip = objTemp.Zip,
                                Zip4 = objTemp.Zip4,
                                PatientLastFour = objTemp.PatientLastFour
                            }
                        };
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<PATIENT> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<PATIENT> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_PATIENT_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<PATIENT> GetItemsByName(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string LAST_NAME, string FIRST_NAME)
        {
            List<PATIENT> objReturn = null;
            List<PatientComplete> objTemp = null;

            //TODO: Revist

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objTemp = dbContext.usp_PATIENT_getitemsByName(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME).ToList();
                    LogManager.LogTiming(logDetails);

                    if (objTemp != null)
                    {
                        objReturn = new List<PATIENT>();

                        foreach (PatientComplete p in objTemp)
                        {
                            PATIENT newPatient = new PATIENT()
                            {
                                BIRTH_DATE = p.BIRTH_DATE,
                                CELL_PHONE = p.CELL_PHONE,
                                CREATED = p.CREATED,
                                CREATEDBY = p.CREATEDBY,
                                DEATH_DATE = p.DEATH_DATE,
                                EMAIL_ADDRESS = p.EMAIL_ADDRESS,
                                FIRST_NAME = p.FIRST_NAME,
                                LAST_NAME = p.LAST_NAME,
                                MIDDLE_NAME = p.MIDDLE_NAME,
                                OEFOIF_IND = p.OEFOIF_IND,
                                PATIENT_ID = p.PATIENT_ID,
                                PATIENTSID = p.PATIENTSID,
                                PERFERRED_ADDRESS_TYPE = p.PERFERRED_ADDRESS_TYPE,
                                UPDATED = p.UPDATED,
                                UPDATEDBY = p.UPDATEDBY,
                                PatientICN = p.PatientICN,
                                SPATIENT = new SPATIENT()
                                {
                                    AddressChangeInstitutionIEN = p.AddressChangeInstitutionIEN,
                                    AddressChangeInstitutionSID = p.AddressChangeInstitutionSID,
                                    AddressChangeStaffIEN = p.AddressChangeStaffIEN,
                                    AddressChangeStaffSID = p.AddressChangeStaffSID,
                                    Age = p.Age,
                                    BadAddressIndicator = p.BadAddressIndicator,
                                    CDDeterminingInstitutionIEN = p.CDDeterminingInstitutionIEN,
                                    City = p.City,
                                    CombatFromVistaDate = p.CombatFromVistaDate,
                                    CombatToVistaDate = p.CombatToVistaDate,
                                    ConfidentialAddressActiveFlag = p.ConfidentialAddressActiveFlag,
                                    Country = p.Country,
                                    CountryIEN = p.CountryIEN,
                                    CountrySID = p.CountrySID,
                                    County = p.County,
                                    Created = p.Created,
                                    CreatedBy = p.CreatedBy,
                                    CurrentMeansTestStatusIEN = p.CurrentMeansTestStatusIEN,
                                    DateOfBirth = p.DateOfBirth,
                                    DateOfBirthText = p.DateOfBirthText,
                                    DateOfDeath = p.DateOfDeath,
                                    DateOfDeathText = p.DateOfDeathText,
                                    Deceased = p.Deceased,
                                    DEFAULT_RECORD = p.DEFAULT_RECORD,
                                    Eligibility = p.Eligibility,
                                    EligibilityIEN = p.EligibilityIEN,
                                    EligibilitySID = p.EligibilitySID,
                                    EligibilityStatus = p.EligibilityStatus,
                                    EligibilityVACode = p.EligibilityVACode,
                                    EligibilityVerificationSource = p.EligibilityVerificationSource,
                                    EmailAddress = p.EmailAddress,
                                    EnteredIntoFileDate = p.EnteredIntoFileDate,
                                    EnteredIntoFileDateTransformSID = p.EnteredIntoFileDateTransformSID,
                                    EnteredIntoFileVistaErrorDate = p.EnteredIntoFileVistaErrorDate,
                                    ETLBatchID = p.ETLBatchID,
                                    ExcludeFromFacilityDirectoryFlag = p.ExcludeFromFacilityDirectoryFlag,
                                    Gender = p.Gender,
                                    GISAddressType = p.GISAddressType,
                                    GISAddressUpdatedDate = p.GISAddressUpdatedDate,
                                    GISCongressDistrict = p.GISCongressDistrict,
                                    GISFIPSCode = p.GISFIPSCode,
                                    GISLocatorName = p.GISLocatorName,
                                    GISMarket = p.GISMarket,
                                    GISMatchedAddress = p.GISMatchedAddress,
                                    GISMatchMethodCode = p.GISMatchMethodCode,
                                    GISMatchScore = p.GISMatchScore,
                                    GISMatchStatusCode = p.GISMatchStatusCode,
                                    GISPatientAddressLatitude = p.GISPatientAddressLatitude,
                                    GISPatientAddressLongitude = p.GISPatientAddressLongitude,
                                    GISSector = p.GISSector,
                                    GISStreetSide = p.GISStreetSide,
                                    GISSubmarket = p.GISSubmarket,
                                    GISURH = p.GISURH,
                                    InsuranceCoverageFlag = p.InsuranceCoverageFlag,
                                    LastServiceEntryDate = p.LastServiceEntryDate,
                                    LastServiceEntryDateTransformSID = p.LastServiceEntryDateTransformSID,
                                    LastServiceEntryVistaErrorDate = p.LastServiceEntryVistaErrorDate,
                                    LastServiceSeparationDate = p.LastServiceSeparationDate,
                                    LastServiceSeparationDateTransformSID = p.LastServiceSeparationDateTransformSID,
                                    LastServiceSeparationVistaErrorDate = p.LastServiceSeparationVistaErrorDate,
                                    MaritalStatus = p.MaritalStatus,
                                    MaritalStatusIEN = p.MaritalStatusIEN,
                                    MaritalStatusSID = p.MaritalStatusSID,
                                    MedicaidNumber = p.MedicaidNumber,
                                    MothersMaidenName = p.MothersMaidenName,
                                    OEF_OIF_IND = p.SOEF_OIF_IND,
                                    OpCode = p.OpCode,
                                    Patient_ID = p.Patient_ID,
                                    PatientFirstName = p.PatientFirstName,
                                    PatientICN = p.SPatientICN,
                                    PatientICNChecksum = p.PatientICNChecksum,
                                    PatientIEN = p.PatientIEN,
                                    PatientLastName = p.PatientLastName,
                                    PatientName = p.PatientName,
                                    PatientSID = p.PatientSID,
                                    PatientSnum = p.PatientSnum,
                                    PercentServiceConnect = p.PercentServiceConnect,
                                    PeriodOfService = p.PeriodOfService,
                                    PeriodOfServiceIEN = p.PeriodOfServiceIEN,
                                    PeriodOfServiceSID = p.PeriodOfServiceSID,
                                    PhoneCellular = p.PhoneCellular,
                                    PhoneResidence = p.PhoneResidence,
                                    PhoneWork = p.PhoneWork,
                                    PK_ID = p.PK_ID,
                                    PostalCode = p.PostalCode,
                                    POWLocationIEN = p.POWLocationIEN,
                                    PreferredInstitutionIEN = p.PreferredInstitutionIEN,
                                    Province = p.Province,
                                    PseudoSSNFlag = p.PseudoSSNFlag,
                                    PurpleHeartInstitutionIEN = p.PurpleHeartInstitutionIEN,
                                    Race = p.Race,
                                    RaceIEN = p.RaceIEN,
                                    RaceSID = p.RaceSID,
                                    Religion = p.Religion,
                                    ReligionIEN = p.ReligionIEN,
                                    ReligionSID = p.ReligionSID,
                                    RoomBedIEN = p.RoomBedIEN,
                                    ScrSnum = p.ScrSnum,
                                    SensitiveFlag = p.SensitiveFlag,
                                    Sta3n = p.Sta3n,
                                    State = p.State,
                                    StateIEN = p.StateIEN,
                                    StateSID = p.StateSID,
                                    STD_COMBATLOCATION_ID = p.STD_COMBATLOCATION_ID,
                                    STD_ENTHNICITY_ID = p.STD_ENTHNICITY_ID,
                                    STD_GENDER_ID = p.STD_GENDER_ID,
                                    STD_MARITALSTATUS_ID = p.STD_MARITALSTATUS_ID,
                                    STD_RACE_ID = p.STD_RACE_ID,
                                    STD_SERVICEBRANCH_ID = p.STD_SERVICEBRANCH_ID,
                                    StdRegistryId = p.StdRegistryId,
                                    StreetAddress1 = p.StreetAddress1,
                                    StreetAddress2 = p.StreetAddress2,
                                    StreetAddress3 = p.StreetAddress3,
                                    TemporaryAddressChangeInstitutionIEN = p.TemporaryAddressChangeInstitutionIEN,
                                    Updatedate = p.Updatedate,
                                    UpdatedBy = p.UpdatedBy,
                                    VeteranFlag = p.VeteranFlag,
                                    VistaCreateDate = p.VistaCreateDate,
                                    VistaEditDate = p.VistaEditDate,
                                    Zip = p.Zip,
                                    Zip4 = p.Zip4,
                                    PatientLastFour = p.PatientLastFour
                                }
                            };

                            objReturn.Add(newPatient);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		#endregion
	}
}
